# Vibe Coding AI 应用开发


你好，我是鱼皮。

如今，AI 已经不再是遥不可及的高科技，而是每个开发者都可以轻松使用的工具。通过调用 AI API，你可以快速做出各种智能应用，比如聊天助手、写作助手、图片生成器等。这些项目不仅有趣，而且非常实用，做出来可以直接用，也可以作为你的作品集项目。

这篇文章，我会带你做 4 个热门的 AI 应用：AI 聊天助手、智能写作助手、AI 图片生成器、语音识别应用。

需要先说明的是，本节教程更多的是做一个思路和项目开发流程的指导，目的是引导大家学会使用 Vibe Coding 开发项目的方法，需要大家自行动手实践。如果你需要更完整的 Vibe Coding 图文和视频教程，可以看看鱼皮的原创项目实战部分。



## 一、AI 应用开发基础

在开始做项目之前，我们先了解一下 AI 应用开发的基础知识。

AI 应用就是利用 AI 能力（比如文本生成、图片生成、语音识别等）来解决实际问题的应用程序。你不需要训练 AI 模型，只需要调用现成的 AI API 就可以了。这就像你不需要知道汽车引擎怎么工作，只需要会开车就行。

目前主流的 AI API 服务有很多。文本生成方面，有 OpenAI 的 GPT-4、Anthropic 的 Claude、Google 的 Gemini，还有国产大模型比如通义千问、文心一言、智谱 AI 等。图片生成方面，有 DALL-E 3、Midjourney、Stable Diffusion，还有国产的文心一格等。语音识别方面，有 OpenAI 的 Whisper、Google Speech-to-Text、讯飞语音识别等。

AI 应用的开发流程和普通应用类似，只是多了一个调用 AI API 的步骤。整个流程是：用户输入 → 处理输入 → 调用 AI API → 处理 AI 响应 → 展示结果。

听起来很简单对吧？确实，AI 应用开发的门槛已经非常低了。

![](https://pic.yupi.icu/1/aiapp-workflow%E5%A4%A7.jpeg)

在开发 AI 应用时，有几个注意事项。

首先是 API Key 安全，不要把 API Key 暴露在前端代码中，否则别人可以盗用你的 Key。其次是成本控制，AI API 按使用量收费，要控制好成本，避免浪费。第三是错误处理，API 调用可能失败，要做好错误处理，给用户友好的提示。最后是用户体验，AI 响应可能需要几秒钟，要有加载提示，让用户知道正在处理。



## 二、项目实战 - AI 聊天助手

AI 聊天助手是最基础也是最实用的 AI 应用。通过这个项目，你可以学习如何用 Vibe Coding 的方式快速开发一个完整的 AI 对话应用。

这个项目要实现一个完整的聊天界面，用户可以输入问题，AI 给出回答。要支持多轮对话，AI 能记住之前说过的内容，这样对话才连贯。为了更好的体验，AI 的回答要逐字显示，而不是一次性全部出现，这叫流式输出。对话记录要保存在本地，刷新页面也不会丢失。另外，还需要一个清空对话的功能，方便开始新的话题。

![](https://pic.yupi.icu/1/demoweb6.png)

技术选型上，我们使用 React + TypeScript + Vite 作为前端框架，Tailwind CSS 来写样式。AI 能力通过调用大模型 API 实现，对话历史用 LocalStorage 保存，AI 的回答用 react-markdown 来渲染，这样可以支持代码高亮等格式。



### 开发步骤

1）准备工作

开发的第一步是准备工作。你需要获取 API Key 来调用 AI 模型。访问 [智谱 AI 开放平台](https://bigmodel.cn)，进入用户控制台，点击 API Key 就可以获取。智谱 AI 提供的 GLM 模型效果不错，而且有免费额度，适合学习使用。

2）写需求文档

有了 API Key，就可以开始写需求文档了。创建 `PRD.md` 文件，明确你要做什么：

```markdown
# AI 聊天助手 PRD

## 核心功能
1. 用户可以输入问题，AI 给出回答
2. 支持多轮对话，AI 能记住之前的对话内容
3. AI 回答要逐字显示，不要一次性全部出现
4. 对话记录要保存在本地，刷新页面不会丢失
5. 可以清空对话，开始新的话题
6. AI 的回答支持 Markdown 格式，包括代码高亮

## 界面要求
- 类似微信的聊天界面
- 用户消息在右边，AI 消息在左边
- 底部有输入框和发送按钮
- 简洁现代的设计风格
```

这个文档清楚地说明了要实现什么功能，界面是什么样的。

3）写技术设计文档

然后写技术设计文档 `TECH_DESIGN.md`：

```markdown
# 技术设计

## 技术栈
- React + TypeScript + Vite
- Tailwind CSS
- 智谱 AI API
- LocalStorage 存储对话历史
- react-markdown 渲染 Markdown

## 数据结构
- Message: role（user 或 assistant）、content（内容）、timestamp（时间戳）
- 对话历史存储在 LocalStorage 中

## API 调用
- 使用智谱 AI Chat Completions API
- 启用 stream 模式实现流式输出
- API Key 存储在环境变量中
```

这个文档说明了用什么技术，数据结构是什么样的，API 怎么调用。

4）写 AGENTS.md 文件

接着创建 `AGENTS.md` 文件，告诉 AI 开发规范：

```markdown
# AI 聊天助手开发指令

## 项目概述
使用 React + TypeScript 开发的 AI 聊天助手，调用智谱 AI API 实现对话功能。

## 开发规范
- 使用 TypeScript，确保类型安全
- 使用 Tailwind CSS 编写样式
- API Key 从环境变量读取，不要硬编码
- 错误要有友好的提示

## 功能要求
- 实现流式输出，AI 回答要逐字显示
- 支持多轮对话，要把历史消息发送给 API
- 对话历史要保存在 LocalStorage
- 支持 Markdown 渲染和代码高亮

## 注意事项
- 要处理 API 调用失败的情况
- 加载时要有明确的提示
- 输入框在发送时要禁用，避免重复发送
```

这个文件是给 AI 的开发规范，让它知道代码要怎么写。

5）和 AI 对话开发

有了这三个文档，就可以开始和 AI 对话开发了。打开 Cursor，把这 3 个文档放在项目根目录。

第一步是初始化项目：

```
请根据 PRD.md、TECH_DESIGN.md 和 AGENTS.md 的要求，初始化一个 React + TypeScript + Vite 项目，并安装必要的依赖：Tailwind CSS、react-markdown、react-syntax-highlighter。
```

这个提示词告诉 AI 要创建什么项目，安装哪些依赖。AI 会读取这三个文档，然后按照要求创建项目结构，安装依赖，配置 Tailwind CSS。

第二步是创建数据类型和 API 封装：

```
创建 types.ts 文件，定义 Message 类型。然后创建 api.ts 文件，封装智谱 AI API 调用，要支持流式输出，参数从环境变量读取。
```

这一步是为后续开发打基础，把数据结构和 API 调用都封装好，后面用起来就很方便。

第三步是实现聊天界面：

```
创建 ChatInterface 组件，实现聊天界面。要求：
1. 消息列表显示在上方，用户消息在右边，AI 消息在左边
2. 底部有输入框和发送按钮
3. 使用 Tailwind CSS 实现类似微信的聊天界面样式
4. 消息要支持 Markdown 渲染
```

这个提示词说明了界面的布局和样式要求。AI 会创建完整的聊天界面组件。

第四步是实现对话功能：

```
实现发送消息的功能：
1. 用户输入消息后，添加到消息列表
2. 调用 API 获取 AI 回答
3. 使用流式输出，逐字显示 AI 的回答
4. 要把历史消息也发送给 API，实现多轮对话
5. 加载时禁用输入框，显示"思考中..."
```

这个提示词包含了对话功能的所有要求。流式输出是关键，它让 AI 的回答像打字一样逐字出现，用户体验会好很多。多轮对话也很重要，要把之前的对话历史一起发送给 API，这样 AI 才能记住之前说过的内容。

第五步是添加数据持久化：

```
使用 LocalStorage 保存对话历史：
1. 每次对话更新后自动保存
2. 页面加载时读取历史记录
3. 添加"清空对话"按钮，清除历史记录
```

这样用户刷新页面后，之前的对话还在，不会丢失。

第六步是优化用户体验：

```
优化用户体验：
1. 新消息出现时，自动滚动到底部
2. 添加复制按钮，方便复制 AI 的回答
3. 代码块要有语法高亮
4. API 调用失败时，显示友好的错误提示
```

这些细节虽然小，但能大幅提升用户体验。



### 开发技巧

在开发过程中，有几个技巧可以让你更高效。首先，不要一次性让 AI 实现所有功能，而是分成多个小步骤，每完成一步就测试一下。这样即使出问题，也容易定位和修复。

其次，在对话时要给 AI 提供足够的上下文。明确告诉它要实现什么功能、有什么具体要求、要遵循什么规范。上下文越清晰，AI 生成的代码质量就越高。

如果代码出现问题，记得把完整的错误信息发给 AI，让它帮你分析和修复。不要只说 “代码报错了”，而是要把具体的错误信息粘贴给它。



### 扩展思路

基础版完成后，你可以继续扩展功能。

比如添加系统提示词设置，让 AI 扮演不同角色（比如编程助手、写作助手、心理咨询师等）；支持多个对话会话管理，可以同时进行多个话题的对话；添加语音输入功能，用语音和 AI 对话；集成图片识别功能，让 AI 可以看图回答问题；支持导出对话记录，保存重要的对话内容。



## 三、项目实战 - 智能写作助手

掌握了 AI 对话的基本流程后，让我们来做一个更专业的应用 —— 智能写作助手。写作助手是 AI 最实用的应用场景之一，通过这个项目，你可以学习如何用提示词工程让 AI 完成不同的写作任务。

这个项目要支持多种写作模式，比如文章续写、内容改写、文案生成、邮件撰写等。用户可以调整创意度和输出长度等参数，控制 AI 的生成效果。还可以一键优化文本的语法和表达，让文字更专业。为了方便选择，可以一次生成多个版本，用户挑选最满意的。生成的内容要保存到历史记录中，方便查看和管理。

![](https://pic.yupi.icu/1/demoweb7.png)

技术栈和聊天助手类似，使用 React + TypeScript + Vite，配合 Tailwind CSS。核心还是调用智谱 AI API，数据用 LocalStorage 保存。



### 开发步骤

1）设计提示词模板

开发的第一步是设计提示词模板。在开始写代码之前，先设计好不同写作任务的提示词。创建一个 `prompts.md` 文件，定义各种写作模式的提示词：

```markdown
# 写作助手提示词模板

## 文章续写
请继续写下面的文章，保持风格一致，内容连贯：
[用户输入的内容]

## 内容改写
请改写下面的内容，使其更加流畅、专业：
[用户输入的内容]

## 内容扩展
请扩展下面的内容，增加更多细节和例子：
[用户输入的内容]

## 内容总结
请总结下面的内容，提取核心要点：
[用户输入的内容]

## 邮件撰写
请写一封[正式/友好]的邮件，主题是：[主题]

## 文案生成
请为[产品名称]写一段[风格]风格的营销文案
```

提示词是 AI 应用的核心，好的提示词能让 AI 生成更好的结果。一个好的提示词通常包含 3 个要素：明确的任务描述、充足的上下文信息、清晰的输出格式要求。

![](https://pic.yupi.icu/1/promptcompare%E5%A4%A7.jpeg)

举个例子，如果你想让 AI 写一篇文章，不要只说 “帮我写一篇文章”，而要说清楚主题、读者对象、字数要求、包含哪些内容。比如：

```markdown
请写一篇关于 AI 编程的科普文章，面向零基础读者，通俗易懂，多举例子，字数 800-1000 字，要包含什么是 AI 编程、为什么要学、如何入门。 
```

这样 AI 才知道应该怎么写。

如果是改写内容，要告诉 AI 这段内容的背景。比如：

```markdown
这是一篇技术博客的开头段落，请改写得更吸引人，同时保持专业性。
```

这样 AI 才知道应该往什么方向改。

指定输出格式也很重要。如果你想让 AI 总结文章，可以明确要求：

```markdown
请总结这篇文章，输出格式：
1. 核心观点（3-5 条）
2. 关键数据（如果有）
3. 结论（一句话）
```

这样生成的结果更规范，更符合你的需求。

有时候，给 AI 一些示例效果会更好。比如让 AI 写营销文案，你可以先给几个示例，让它参考风格。这种方法叫 Few-shot Learning，在很多场景下都很有效。

2）写需求文档

设计好提示词模板后，就可以写需求文档了。创建 `PRD.md` 文件：

```markdown
# 智能写作助手 PRD

## 核心功能
1. 左右分栏布局，左侧输入，右侧显示生成结果
2. 支持 6 种写作模式：续写、改写、扩展、总结、邮件、文案
3. 可以调整创意度（temperature）和输出长度
4. 生成的内容要流式显示
5. 有"优化提示词"按钮，AI 帮用户优化描述
6. 保存生成历史

## 界面要求
- 顶部：大标题
- 输入区：大文本框（多行）
- 参数区：尺寸选择、风格选择
- 按钮区：优化提示词、生成内容
- 展示区：显示生成的内容 + 复制按钮
- 侧边栏：历史记录
```

3）和 AI 对话开发

有了文档，就可以和 AI 对话开发了。

第一步，创建基础界面：

```
请根据 PRD.md 创建智能写作助手的界面：
1. 左右分栏布局
2. 左侧：模式选择下拉框 + 输入文本框 + 生成按钮
3. 右侧：显示生成的内容
4. 使用 Tailwind CSS，界面要美观
```

第二步，实现提示词模板：

```
创建 promptTemplates.ts 文件，根据 prompts.md 中的模板，实现 6 种写作模式的提示词函数。每个函数接收用户输入，返回完整的提示词。
```

这样就把提示词逻辑封装好了，不同的写作模式用不同的提示词。

第三步，实现生成功能：

```
实现内容生成功能：
1. 用户选择模式，输入内容，点击生成
2. 根据选择的模式，生成对应的提示词
3. 调用智谱 AI API，使用流式输出
4. 在右侧实时显示生成的内容
5. 支持 Markdown 渲染
```

第四步，添加参数调整：

```
添加高级设置面板：
1. 创意度滑块（temperature: 0-1）
2. 输出长度滑块（max_tokens: 100-2000）
3. 这些参数要传递给 API 调用
4. 可以折叠/展开高级设置
```

temperature 值会影响输出的创意程度。

- 0-0.3 比较保守，适合事实性内容
- 0.4-0.7 比较平衡，适合大多数场景
- 0.8-1.0 很有创意，适合创意写作。

第五步，添加历史记录：

```
实现历史记录功能：
1. 每次生成后，保存到 LocalStorage
2. 保存内容：提示词、生成结果、生成时间
3. 左侧显示历史记录列表
4. 点击历史记录可以查看之前的内容
5. 支持删除历史记录
```



### 提示词优化技巧

如果你不确定提示词是否够好，可以让 AI 帮你优化。比如你可以这样问：

```
我想让 AI 帮我改写文章，让文章更专业。我现在的提示词是："请改写这段话"。请帮我优化这个提示词，让 AI 生成更好的结果。
```

AI 会给你一个更详细、更有效的提示词，比如：

```markdown
这是一篇技术博客的开头段落，请改写得更吸引人，同时保持专业性。要求：
1. 用更生动的语言
2. 保持技术准确性
3. 字数控制在 200 字左右
```



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加更多写作模板，支持论文、报告、小说等不同类型的写作；支持自定义提示词模板，让用户可以创建自己的模板；添加多语言翻译功能，一键翻译成其他语言；实现批量生成，一次生成多个版本供选择；添加文本对比功能，对比不同版本的差异。



## 四、项目实战 - AI 图片生成器

从文本生成到图片生成，让我们来做一个更酷的 AI 应用。AI 图片生成是最酷的 AI 应用之一，通过简单的文字描述，就能生成精美的图片。这个项目可以让你学习如何调用图片生成 API。

这个项目的核心是文字生成图片。用户输入描述，选择尺寸和风格，点击生成就能得到图片。为了帮助用户写出更好的提示词，可以添加一个 “优化提示词” 功能，让 AI 帮用户把简单的描述扩展成详细的提示词。生成的图片要保存到历史记录，并且支持下载。

![](https://pic.yupi.icu/1/demoweb8.png)

技术栈和前面的项目类似，主要是调用图片生成 API。智谱 AI 也提供了图片生成能力，你可以使用同一个 API Key，[访问官方获取](https://bigmodel.cn)。



### 开发步骤

1）了解图片生成 API

开发的第一步是了解图片生成 API。图片生成 API 的主要参数包括：

- prompt：图片描述（最重要）
- size：图片尺寸（比如 1024x1024）
- quality：质量（标准或高清）
- style：风格（写实或艺术）

不同的参数组合会生成不同效果的图片。

2）写需求文档

然后写需求文档 `PRD.md`：

```markdown
# AI 图片生成器 PRD

## 核心功能
1. 用户输入图片描述，点击生成
2. 可以选择图片尺寸和风格
3. 生成过程显示加载动画（通常需要 10-30 秒）
4. 生成后显示图片，可以下载
5. 有"优化提示词"按钮，AI 帮用户优化描述
6. 保存生成历史

## 界面要求
- 顶部：大标题
- 输入区：大文本框（多行）
- 参数区：尺寸选择、风格选择
- 按钮区：优化提示词、生成图片
- 展示区：显示生成的图片 + 下载按钮
- 侧边栏：历史记录
```

3）与 AI 对话开发

有了文档，就可以和 AI 对话开发了。

第一步，创建基础界面：

```
请根据 PRD.md 创建 AI 图片生成器的界面：
1. 输入框：用户输入图片描述
2. 参数选择：尺寸（3 个选项）、风格（2 个选项）
3. 两个按钮：优化提示词、生成图片
4. 图片展示区
使用 Tailwind CSS，界面要美观。
```

第二步，实现图片生成功能：

```
实现图片生成功能：
1. 调用智谱 AI 图片生成 API
2. 发送 prompt、size、style 参数
3. 生成过程显示加载动画和提示文字
4. 生成成功后显示图片
5. 错误时显示友好提示
```

图片生成通常需要 10 ~ 30 秒，所以加载提示很重要，要让用户知道正在生成，不是卡住了。

第三步，实现提示词优化功能：

```
实现提示词优化功能：
当用户点击"优化提示词"按钮时：
1. 把用户输入的简单描述发送给 AI
2. 让 AI 扩展成详细的图片生成提示词
3. 提示词要包含：主体、风格、光线、色彩、构图等细节
4. 把优化后的提示词填回输入框
```

这个功能很实用，可以帮助不会写提示词的用户生成更好的图片。

第四步，添加历史记录：

```
实现历史记录功能：
1. 每次生成成功后，保存到 LocalStorage
2. 保存内容：提示词、图片 URL、生成时间
3. 左侧显示历史记录列表（缩略图 + 提示词）
4. 点击历史记录可以查看大图
5. 支持删除历史记录
```

第五步，添加下载功能：

```
实现图片下载功能：
点击下载按钮时，下载当前显示的图片。
文件名格式：ai-image-[时间戳].png
```



### 图片生成提示词技巧

图片生成的质量很大程度上取决于提示词。一个好的提示词通常包含这些元素：主体（画什么）、动作或状态（在做什么）、环境背景（在哪里）、风格（什么风格）、光线（什么光线）、色彩（什么色调）、质量词（高清 / 4K 等）。

比如，如果你想生成一只猫的图片，可以这样描述：

```markdown
一只可爱的橘猫，坐在窗台上看着外面的雨，温暖的室内光线，柔和的色调，细腻的毛发质感，景深效果，高清画质，4K。
```

这样的描述包含了所有关键要素，生成的图片质量会更好。

关于风格，你可以用一些关键词来指定。写实风格用 photorealistic、realistic、detailed；卡通风格用 cartoon style、anime style、cute；油画风格用 oil painting、artistic、impressionist；水彩风格用 watercolor、soft colors；赛博朋克风格用 cyberpunk、neon lights、futuristic。

质量词也很重要，比如 high quality、detailed、4K、8K、professional、masterpiece 等，这些词能让 AI 生成更精细的图片。

如果你不确定怎么写提示词，可以让 AI 帮你。比如你想生成一张图片，内容是一个程序员在咖啡厅写代码。你可以告诉 AI：

```
我想生成一张图片，内容是：一个程序员在咖啡厅写代码。请帮我把这个描述扩展成详细的图片生成提示词。
```

AI 会给你一个详细的描述，包含场景、光线、色调、构图等各个方面。比如：

```markdown
一位年轻的程序员坐在温馨的咖啡厅靠窗位置，专注地在笔记本电脑上写代码，桌上放着一杯热气腾腾的拿铁咖啡，温暖的下午阳光透过窗户洒在桌面上，背景是模糊的咖啡厅环境，柔和的光线，温暖的色调，电影感构图，景深效果，高清画质，专业摄影。
```

💡 如果用的是国外的 AI 绘图模型，英文提示词的效果可能会更好哦。



### 成本控制建议

需要注意的是，图片生成比文本生成贵很多，要注意控制成本。开发测试时用标准质量就够了，不需要用高清质量。优化好提示词再生成，避免反复尝试浪费额度。如果预算有限，可以考虑使用更便宜的替代方案。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加图片编辑功能，基于现有图片修改；支持批量生成，一次生成多张图片；添加风格预设，一键选择常用风格；实现图片放大功能，查看细节；甚至可以添加社区分享功能，让用户分享自己生成的图片。



## 五、项目实战 - 语音识别应用

最后，让我们来做一个涉及音频处理的 AI 应用。语音识别可以让你的应用支持语音输入，大大提升用户体验。这个项目可以让你学习如何处理音频数据，调用语音识别 API。

这个项目要实现语音录制和识别功能。用户点击按钮开始录音，再点击停止，然后将语音转换为文字。要支持多种语言，识别结果可以编辑，并保存到历史记录中。

![](https://pic.yupi.icu/1/demoweb9.png)

录音功能使用浏览器自带的 MediaRecorder API，不需要额外的库。语音识别调用智谱 AI 的语音识别能力，[访问官方获取 API Key](https://bigmodel.cn/)。其他技术栈和前面的项目类似。



### 开发步骤

1）了解语音识别 API

开发的第一步是了解语音识别 API。语音识别 API 的调用很简单：上传音频文件，指定语言（可选），返回识别的文字。

2）写需求文档

然后写需求文档 `PRD.md`：

```markdown
# 语音识别应用 PRD

## 核心功能
1. 大大的录音按钮，点击开始录音，再点击停止
2. 录音时按钮变红色，有动画效果
3. 停止后显示"开始识别"按钮
4. 识别过程显示加载提示
5. 识别结果显示在下方，可以编辑
6. 保存识别历史

## 界面要求
- 简洁的单页面
- 中央大圆形录音按钮
- 识别结果区域
- 底部历史记录列表
```

3）与 AI 对话开发

有了文档，就可以和 AI 对话开发了。

第一步，实现录音功能：

```
请实现浏览器录音功能：
1. 使用 MediaRecorder API 录制音频
2. 需要请求麦克风权限
3. 点击按钮开始录音，再点击停止
4. 录音时按钮变红色，有脉冲动画
5. 停止后保存音频数据（Blob 格式）
```

这个提示词说明了要用什么技术，实现什么功能。MediaRecorder API 是浏览器提供的录音接口，不需要额外安装库，非常方便。

第二步，实现语音识别：

```
实现语音识别功能：
1. 调用智谱 AI 语音识别 API
2. 上传录音的音频文件
3. 指定语言为中文
4. 显示识别结果
5. 错误时显示友好提示
```

第三步，优化界面和体验：

```
优化界面和用户体验：
1. 录音按钮要大且醒目（直径 120px）
2. 识别结果区域要支持编辑
3. 添加复制按钮，方便复制识别结果
4. 识别过程显示加载动画和提示文字
5. 整体使用简洁现代的设计
```

第四步，添加历史记录：

```
实现历史记录功能：
1. 每次识别成功后保存到 LocalStorage
2. 保存内容：识别文本、时间戳
3. 底部显示历史记录列表
4. 点击历史记录可以查看详情
5. 支持删除历史记录
```



### 开发技巧

在开发过程中，有几个技巧需要注意。首先是处理麦克风权限，第一次使用时浏览器会询问用户是否允许访问麦克风。如果用户拒绝，要给出友好提示：“需要麦克风权限才能录音，请在浏览器设置中允许访问麦克风”，并提供重新请求权限的按钮。

其次是音频格式处理。MediaRecorder 录制的音频格式可能是 webm，大部分语音识别 API 都支持这个格式，如果不支持可以让 AI 帮你转换格式。

第三是录音时长限制。为了避免文件太大和识别时间太长，可以限制录音时长，比如最长录音 60 秒。录音时显示倒计时，到达时间自动停止。还可以实时显示录音时长，让用户知道录了多久。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加语音翻译功能，识别后自动翻译成其他语言；支持实时识别，边说边识别；添加关键词提取功能，自动提取重要信息；支持多人对话识别，区分不同说话人；添加字幕生成功能，给视频生成字幕；甚至可以集成到其他应用，比如聊天助手，让聊天助手支持语音输入。



## 写在最后

通过这 4 个 AI 应用项目，你已经学习了 AI 应用开发的基本流程：从简单的聊天助手，到专业的写作助手，从酷炫的图片生成器，到实用的语音识别应用。每个项目都让你掌握了不同的 AI 能力。

AI 应用开发的门槛已经非常低了，你不需要懂复杂的机器学习算法，只需要会调用 API、设计好的提示词，就能做出很酷的应用。如果你想学习更多的 AI 应用开发技巧和最佳实践，可以参考本教程的经验技巧板块。

掌握了 AI 应用开发后，在下一篇文章中，我会带你挑战更复杂的全栈应用开发，学习如何处理前后端和数据库。让我们继续前进！



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
